import 'package:flutter/material.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:top_news_app/localization/localization.dart';
import 'package:top_news_app/model/Article.dart';
import 'package:top_news_app/screen/author_post_screens.dart';
import 'package:top_news_app/screen/category_ways_post_list_screen.dart';
import 'package:top_news_app/screen/comments_screen.dart';
import 'package:top_news_app/screen/news_details_screen.dart';
import 'package:google_fonts/google_fonts.dart';
import '../helper/image_cached.dart';
import '../providers/article_provider.dart';
import '../services/storage_service.dart';

class NewsCardWidgetLgThree extends StatefulWidget {
  final ArticleData post;

  const NewsCardWidgetLgThree({super.key, required this.post});
  @override
  State<NewsCardWidgetLgThree> createState() => _NewsCardWidgetLgThreeState();

}

class _NewsCardWidgetLgThreeState extends State<NewsCardWidgetLgThree> {

  bool isAuth = false;
  var storage = StorageService();
  bool isBookMark = false;
  var articleProvider = ArticleProvider();


  bookMark() {
    if(!isAuth){
      dialogLogin(context);
    }else{
      storeBookMark();
    }

  }

  storeBookMark() async{
    isBookMark =  await articleProvider.bookMarking(widget.post.postId);
    setState(() {

    });
  }

  checkAuth() async {
    isAuth = (await storage.isAuthInLocal())!;
    setState(() {
      isBookMark = widget.post.bookmark!;
    });
  }

  @override
  void initState()  {
    super.initState();
    checkAuth();
  }

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Card(
      margin: const EdgeInsets.all(defaultAllSidePadding),
      elevation: elevation,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Padding(
            padding: const EdgeInsets.all(defaultAllSidePadding),
            child: Stack(
              alignment: Alignment.center,
              children: [
                GestureDetector(
                  onTap: (){
                    Navigator.push(context, MaterialPageRoute(builder: (context)=> NewsDetailsScreen(data: widget.post,)));
                  },
                  child: Hero(
                    tag: 'post-${widget.post.randomNumber}',
                    child: ClipRRect(
                        borderRadius: BorderRadius.circular(8),
                        child:ImageCached(image: '${widget.post.thumbnail}',
                          width: size.width,
                          height: 180,
                          fit: BoxFit.cover, blur: false,)
                    ),
                  ),
                ),
                Positioned(
                  bottom: 5,
                  left: 5,
                  child:  Card(
                    color: Colors.white,
                    shape: RoundedRectangleBorder(
                      borderRadius: BorderRadius.circular(8),
                    ),
                    child: GestureDetector(
                      onTap: (){
                        Navigator.push(context, MaterialPageRoute(builder: (context)=>CategoryWaysPostListScreen(title: '${widget.post.categoriesName?[0]}', id: '${widget.post.categoriesId?[0]}',)));
                      },
                      child: Padding(
                        padding: const EdgeInsets.symmetric(vertical: 4,horizontal: 8),
                        child: Text(
                          '${widget.post.categoriesName?[0]}',
                          style: GoogleFonts.robotoSerif(
                              fontWeight: FontWeight.w400,
                              fontSize: 12,
                              color: primaryColors
                          ),
                        ),
                      ),
                    ),
                  ),),

                 Positioned(
                    top: 5,
                    right: 5,
                    child: GestureDetector(
                      onTap: (){
                        bookMark();
                      },
                      child: Card(
                        elevation: elevation,
                        color: isBookMark ? primaryColors : Colors.white,
                        child: Padding(
                          padding: const EdgeInsets.all(3.0),
                          child: Icon(
                            Icons.bookmark_border,
                            size: 24,
                            color: isBookMark ? Colors.white : primaryColors,
                          ),
                        ),
                      ),
                    ))
              ],
            ),
          ),
          customSizeBox(10),
          Container(
            padding: const EdgeInsets.all(defaultAllSidePadding),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                GestureDetector(
                  onTap: (){
                    Navigator.push(context, MaterialPageRoute(builder: (context)=> NewsDetailsScreen(data: widget.post,)));
                  },
                  child: Text(
                    '${widget.post.title}',
                    maxLines: 2,
                    style: TextStyle(
                      fontSize: 16,
                      fontFamily: fontFamily,
                      fontWeight: FontWeight.w500,
                    ),
                  ),
                ),
                customSizeBox(8),
                GestureDetector(
                  onTap: (){
                    Navigator.push(context, MaterialPageRoute(builder: (context)=> NewsDetailsScreen(data: widget.post,)));
                  },
                  child: Text(
                    '${widget.post.shortContent}',
                    maxLines: 4,
                    style: TextStyle(
                      fontSize: 14,
                      fontFamily: fontFamily,
                      fontWeight: FontWeight.w400,
                    ),
                  ),
                ),
                customSizeBox(8),
                Row(
                  mainAxisSize: MainAxisSize.max,
                  mainAxisAlignment:
                  MainAxisAlignment.spaceBetween,
                  crossAxisAlignment:
                  CrossAxisAlignment.center,
                  children: [
                    Row(
                      mainAxisSize: MainAxisSize.max,
                      children: [
                         Icon(
                          Icons.remove_red_eye,
                           color: Theme.of(context).iconTheme.color,
                          size: 18,
                        ),
                        Padding(
                          padding: const EdgeInsets.symmetric(horizontal: 10),
                          child: Text(
                            '${widget.post.views}',
                            style: GoogleFonts.robotoSerif(
                              fontWeight: FontWeight.w500,
                            ),
                          ),
                        ),
                      ],
                    ),
                    Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 10),
                      child: Text(
                        '${widget.post.approvedAt}',
                        style: GoogleFonts.robotoSerif(
                          fontWeight: FontWeight.w500,
                        ),
                      ),
                    ),
                  ],
                ),
                customSizeBox(8),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    GestureDetector(
                      onTap: (){
                        if(isAuth){
                          Navigator.push(context, MaterialPageRoute(builder: (context)=>CommentsScreen(postId: widget.post.postId!,)));
                        }else{
                          dialogLogin(context);
                        }
                      },
                      child: Text(
                        "${widget.post.comments} ${getTranslated(context, 'comments') ?? 'comments'}",
                        style: TextStyle(
                          fontSize: 16,
                          fontFamily: fontFamily,
                          fontWeight: FontWeight.w700,
                        ),
                      ),
                    ),
                    GestureDetector(
                      onTap: (){
                        Navigator.push(context, MaterialPageRoute(builder: (context)=>AuthorPostScreens(name: '${widget.post.authorName}', id: '${widget.post.authorId}', image: '${widget.post.authorAvatar}', randomNumber: widget.post.randomNumber ?? 0,)));
                      },
                      child: Row(
                        mainAxisSize: MainAxisSize.max,
                        children: [
                          Hero(
                            tag: 'avatar-${widget.post.randomNumber}',
                            child: Container(
                              width: 20,
                              height: 20,
                              clipBehavior:
                              Clip.antiAlias,
                              decoration: const BoxDecoration(
                                shape: BoxShape.circle,
                              ),
                              child: Image.network(
                                '${widget.post.authorAvatar}',
                                fit: BoxFit.cover,
                              ),
                            ),
                          ),
                          Padding(
                            padding: const EdgeInsets.symmetric(horizontal: 10),
                            child: Text(
                              '${widget.post.authorName}',
                              style: GoogleFonts.robotoSerif(
                                fontWeight: FontWeight.w500,
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),

        ],
      ),
    );
  }
}
