import 'package:top_news_app/model/language.dart';
import '../repos/exception_handlers.dart';
import '../repos/repository.dart';

class LanguagesService{

  Repository? _repository;

  LanguagesService(){
    _repository = Repository();
  }

  setTranslateValue(String key) async {
    return await _repository?.httpPost('set-translate-value',{'key': key});
  }

  getLanguageValues(int memberId) async {
    return await _repository?.httpGetById(
        'get-language-values', memberId.toString());
  }

  getLanguage() async {
    return await _repository?.httpGet('get-languages');
  }

  getLanguagesByUserId(int? memberId) async {
    var data = await _repository?.httpGetById('get-languages-by-user-id', memberId);
    return processResponse(data);
  }

  makeDefaultLanguage(Language language) async {
    var data = await _repository?.httpPost(
        'make-default-language', language.toJson());
    return processResponse(data);
  }

}