
import '../repos/exception_handlers.dart';
import '../repos/repository.dart';

class ArticleService{
  Repository? _repository;

  ArticleService(){
    _repository = Repository();
  }


  getFeedPosts(page) async{
    var response = await _repository?.httpGet('feed?page=$page');
    return processResponse(response);
  }

  getCategoryPosts(categoryId, page) async{
    var response = await _repository?.httpGet('category/feed/$categoryId?page=$page');
    return processResponse(response);
  }

  getRelatedPost(categoryId) async {
    var response = await _repository?.httpGetById('related/posts',categoryId);
    return processResponse(response);
  }

  getPostDetails(id) async {
    var response = await _repository?.httpGetById('post/details', id);
    return processResponse(response);
  }

  getTrendingPosts() async{
    var response = await _repository?.httpGet('trending/posts');
    return processResponse(response);
  }



  getTopPosts() async{
    var response = await _repository?.httpGet('top/posts');
    return processResponse(response);
  }

  getBrakingPosts() async{
    var response = await _repository?.httpGet('braking/posts');
    return processResponse(response);
  }

  //
  getRandomPolling(positions) async {
    var response = await _repository?.httpGetById('random/poll',positions);
    return processResponse(response);
  }

  getAllPolling() async{
    var response = await _repository?.httpGet('polling');
    return processResponse(response);
  }

  getAds() async{
  var response = await _repository?.httpGet('random/ads/for/home');
  return processResponse(response);
}

  getSliderPosts() async{
    var response = await _repository?.httpGet('slider/post');
    return processResponse(response);
  }

  getPostCategories(type) async{
    var response = await _repository?.httpGetById('categories', type);
    return processResponse(response);
  }

  getSinglePoll(id) async {
    var response = await _repository?.httpGetById('polling', id);
    return processResponse(response);
  }

  getSingleAds(id) async {
    var response = await _repository?.httpGetById('single/ads', id);
    return processResponse(response);
  }

  getAuthors() async {
    var response = await _repository?.httpGet('authors');
    return processResponse(response);
  }


  getAuthor(id) async {
    var response = await _repository?.httpGetById('author',id);
    return processResponse(response);
  }

  getAuthorPosts(id,page) async {
    var response = await _repository?.httpGet('author/posts/$id/?page=$page');
    return processResponse(response);
  }


  bookMark(id) async{
    var response = await _repository?.httpGetById('post/bookmark',id);
    return processResponse(response);
  }

  views(id) async {
    var response = await _repository?.httpGetById('post/view',id);
    return processResponse(response);
  }

  bookmarkPosts() async {
    var response = await _repository?.httpGet('bookmark/posts');
    return processResponse(response);
  }

  getArticleSearch(query) async{
    var response = await _repository?.httpGetById('search/posts', query);
    return processResponse(response);
  }

  setVoting(votingId,optionId) async {
    return await _repository?.httpGet('voting/store/$votingId/$optionId');
  }

  commentStore(postId,message) async {
    var response = await _repository?.httpGet('comment/store/$postId/$message');
    return processResponse(response);
  }

  getComments(id,page) async{
   var response = await _repository?.httpGet('comments/$id/?page=$page');
   return processResponse(response);
  }

}