import 'package:flutter/material.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:top_news_app/repos/exception_handlers.dart';
import 'package:top_news_app/screen/reset_password_2nd.dart';
import 'package:top_news_app/services/auth_service.dart';
import '../localization/localization.dart';


class ResetPassword extends StatefulWidget {
  const ResetPassword({Key? key}) : super(key: key);

  @override
  State<ResetPassword> createState() => _ResetPasswordState();
}

class _ResetPasswordState extends State<ResetPassword> {
  var email = TextEditingController();
  bool isLoading = false;

  passwordReset(context) async {
    setState(() {
      isLoading = true;
    });
    try{
      if(email.text.isEmpty){
        showMessage(getTranslated(context, 'Enter the  email') ?? 'Enter the  email');
      }else{
        var authService = AuthService();
        var response = await authService.forgetPasswordOne(email.text);
        var result =  processResponse(response);
        if(result.containsKey('message')){
          showMessage(result['message']);
        }

        if(result['error'] == true){
        }else{
          Navigator.push(context, MaterialPageRoute(builder: (context) =>  ResetPassword2nd(email: email.text)));
        }
      }
    } catch (e) {
      var message = ExceptionHandlers().getExceptionString(e);
      showMessage(message);
    }

    setState(() {
      isLoading = false;
    });
  }


  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SafeArea(
      child: Scaffold(
        resizeToAvoidBottomInset: false,
        appBar: AppBar(
          leading: Container(),
          backgroundColor: Theme.of(context).scaffoldBackgroundColor,
          elevation: 0,
          actions: [IconButton(icon: Icon(Icons.cancel_outlined,color: Theme.of(context).iconTheme.color,), onPressed: (){
            Navigator.pushReplacementNamed(context, '/main-screen');
          })],
        ),
        body: SingleChildScrollView(
          scrollDirection: Axis.vertical,
          padding: const EdgeInsets.all(12),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: <Widget>[
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 40),
                child: Column(
                  children: <Widget>[
                    Container(
                      height: size.height / 4,
                      decoration:  BoxDecoration(
                        image: DecorationImage(
                            image: Theme.of(context).brightness == Brightness.dark ?   AssetImage(darkLogo) :  AssetImage(lightLogo) ),
                      ),
                    ),
                    const SizedBox(
                      height: 10,
                    ),
                    Text(
                      getTranslated(context, 'Forget Password') ?? "Forget Password",
                      style: GoogleFonts.robotoMono(
                          fontSize: 24, fontWeight: FontWeight.bold),
                    ),
                    const SizedBox(
                      height: 10,
                    ),
                    Text(
                      getTranslated(context, 'Enter your valid email here and click the button, after click the button we send a reset password link belong email address') ?? "Enter your valid email here and click the button, after click the button we send a reset password link belong email address",
                      style: GoogleFonts.robotoMono(fontSize: 12),
                      textAlign: TextAlign.center,
                    ),
                    const SizedBox(
                      height: 10,
                    ),
                  ],
                ),
              ),
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Text(
                    getTranslated(context, 'Email Address') ?? 'Email Address',
                    style: GoogleFonts.robotoMono(
                        fontSize: 14, fontWeight: FontWeight.w400),
                  ),
                  const SizedBox(
                    height: 5,
                  ),
                  TextField(
                    obscureText: false,
                    controller: email,
                    decoration: InputDecoration(
                      hintText: getTranslated(context, 'Enter the email address') ?? 'Enter the email address',
                      hintStyle: GoogleFonts.robotoSerif(
                          fontSize: 14, color: Colors.grey),
                      contentPadding: const EdgeInsets.symmetric(
                          vertical: 0, horizontal: 10),
                      enabledBorder: const OutlineInputBorder(
                          borderRadius:
                              BorderRadius.all(Radius.circular(5)),
                          borderSide: BorderSide(color: Colors.grey)),
                      border: const OutlineInputBorder(
                          borderRadius:
                              BorderRadius.all(Radius.circular(5)),
                          borderSide: BorderSide(color: Colors.grey)),
                    ),
                  ),
                  const SizedBox(
                    height: 30,
                  ),
                ],
              ),
              customSizeBox(30),
              GestureDetector(
                onTap: () {
                  passwordReset(context);
                },
                child: Container(
                    height: 45,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(5.0),
                      color: primaryColorsAccent,
                    ),
                    child:  isLoading ? Center(
                        child: Text(
                          '${getTranslated(context, 'Processing') ?? 'Processing'}....',
                          style: buttonTextStyle,
                        )) :  Center(
                        child: Text(
                          getTranslated(context, 'Send Verification Link') ?? 'Send Verification Link',
                          style: buttonTextStyle,
                        ))),
              ),

              const SizedBox(
                height: 10,
              ),
            ],
          ),
        ),
      ),
    );
  }
}
