
import 'package:flutter/material.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:top_news_app/localization/localization.dart';
import 'package:top_news_app/repos/exception_handlers.dart';
import 'package:top_news_app/services/auth_service.dart';

class RegistrationScreen extends StatefulWidget {
  const RegistrationScreen({super.key});

  @override
  State<RegistrationScreen> createState() => _RegistrationScreenState();

}

class _RegistrationScreenState extends State<RegistrationScreen> {
  final email = TextEditingController();
  final name = TextEditingController();
  final password = TextEditingController();
  final confirmPassword = TextEditingController();

  bool _passwordVisible = true;

  bool obscureText = true;
  final AuthService _authService = AuthService();
  bool isLoading = false;



  register(context) async {
    if(password.text.toString() != confirmPassword.text.toString()){
      showMessage(getTranslated(context, 'Password is not equal') ?? 'Password is not equal');
    }
    try {
      setState(() {
        isLoading = true;
      });

      await _authService.register(
          context, email.text, password.text, name.text);
    } catch (e) {
      ExceptionHandlers().getExceptionString(e);
    }

    setState(() {
      isLoading = false;
    });
  }

  @override
  Widget build(BuildContext context) {
    Size size= MediaQuery.of(context).size;
    return SafeArea(
      child: Scaffold(
        appBar: AppBar(
          leading: Container(),
          backgroundColor: Theme.of(context).scaffoldBackgroundColor,
          elevation: 0,
          actions: [IconButton(icon: Icon(Icons.cancel_outlined,color: Theme.of(context).iconTheme.color,), onPressed: (){
            Navigator.pushReplacementNamed(context, '/main-screen');
          })],
        ),
        body: SingleChildScrollView(
          padding: const EdgeInsets.all(12),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              customSizeBox(30),
              ConstrainedBox(
                constraints: BoxConstraints(
                    maxWidth: size.width / 2.2, maxHeight: 140),
                child: Container(
                  decoration:  BoxDecoration(
                    image:
                    DecorationImage(image: Theme.of(context).brightness == Brightness.dark ?   AssetImage(darkLogo) : const AssetImage('assets/logo.png')),
                  ),
                ),
              ),
              Text(
                getTranslated(context, 'Sign Up') ?? 'Sign Up',
                style: TextStyle(
                    fontWeight: FontWeight.bold,
                    fontFamily: fontFamily,
                    fontSize: 24),
                textAlign: TextAlign.center,
              ),
              customSizeBox(5),
              Text(
                getTranslated(context, 'Follow the simple steps') ?? 'Follow the simple steps',
                style: TextStyle(
                    fontWeight: FontWeight.normal,
                    fontFamily: fontFamily,
                    fontSize: 14),
                textAlign: TextAlign.center,
              ),
              customSizeBox(80),
              TextField(
                decoration:  InputDecoration(
                  labelText: getTranslated(context, 'Name') ?? 'Name',
                  contentPadding: const EdgeInsets.symmetric(vertical: 12.0,horizontal: 20),
                  focusedBorder: const OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.grey, width: 1),
                  ),
                  enabledBorder: const OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.grey, width: 1),
                  ),
                  filled: true,
                ),
                controller: name,
              ),
              customSizeBox(20),
              TextField(
                decoration:  InputDecoration(
                  labelText: getTranslated(context, 'Email') ?? 'Email',
                  contentPadding: const EdgeInsets.symmetric(vertical: 12.0,horizontal: 20),
                  focusedBorder: const OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.grey, width: 1),
                  ),
                  enabledBorder: const OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.grey, width: 1),
                  ),
                  filled: true,

                ),
                keyboardType: TextInputType.emailAddress,
                controller: email,
              ),
              customSizeBox(20),
              TextField(
                obscureText: _passwordVisible,
                decoration: InputDecoration(
                  labelText: getTranslated(context, 'Password') ?? 'Password',
                  contentPadding: const EdgeInsets.symmetric(vertical: 12.0,horizontal: 20),
                  focusedBorder: const OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.grey, width: 1),
                  ),
                  enabledBorder: const OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.grey, width: 1),
                  ),
                  filled: true,

                  suffixIcon: IconButton(
                    icon: Icon(
                      !_passwordVisible
                          ? Icons.visibility
                          : Icons.visibility_off,
                      color: Colors.grey,
                    ),
                    onPressed: () {
                      setState(() {
                        _passwordVisible = !_passwordVisible;
                      });
                    },
                  ),
                ),
                keyboardType: TextInputType.text,
                controller: password,
              ),
              customSizeBox(20),
              TextField(
                obscureText: _passwordVisible,
                decoration: InputDecoration(
                  labelText: getTranslated(context, 'Confirm Password') ?? 'Confirm Password',
                  contentPadding: const EdgeInsets.symmetric(vertical: 12.0,horizontal: 20),
                  focusedBorder: const OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.grey, width: 1),
                  ),
                  enabledBorder: const OutlineInputBorder(
                    borderSide: BorderSide(color: Colors.grey, width: 1),
                  ),
                  filled: true,
                  suffixIcon: IconButton(
                    icon: Icon(
                      !_passwordVisible
                          ? Icons.visibility
                          : Icons.visibility_off,
                      color: Colors.grey,
                    ),
                    onPressed: () {
                      setState(() {
                        _passwordVisible = !_passwordVisible;
                      });
                    },
                  ),
                ),
                keyboardType: TextInputType.text,
                controller: confirmPassword,
              ),
              customSizeBox(30),
              GestureDetector(
                onTap: () {
                  register(context);
                },
                child: Container(
                    height: 45,
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(5.0),
                      color: primaryColorsAccent,
                    ),
                    child: isLoading == false
                        ?  Center(
                        child: Text(
                          getTranslated(context, 'Sign Up') ?? 'Sign Up',
                          style: buttonTextStyle,
                        ))
                        :  Center(
                        child: Text(
                          '${getTranslated(context, 'Processing') ?? 'Processing'}....',
                          style: buttonTextStyle,
                        ))),
              ),
              const SizedBox(
                height: 20,
              ),
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Text(
                    '${getTranslated(context, 'Have A Account') ?? 'Have A Account'}!',
                    style: GoogleFonts.robotoSerif(
                      fontSize: 14,
                    ),
                  ),
                  GestureDetector(
                    onTap: () {
                      Navigator.pushReplacementNamed(context, '/email-login');
                    },
                    child: Text(
                      '  ${getTranslated(context, 'Login') ?? 'Login'}',
                      style: GoogleFonts.robotoSerif(
                          fontSize: 14,
                          color: primaryColors
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
