
import 'package:flutter/material.dart';
import 'package:top_news_app/providers/article_provider.dart';
import 'package:top_news_app/widget/polling_card.dart';
import '../model/Polling.dart';


class PollingScreen extends StatefulWidget {
  const PollingScreen({super.key});

  @override

  State<PollingScreen> createState() => _PollingScreenState();
}

class _PollingScreenState extends State<PollingScreen> {


  bool _isLoading = false;
  List<PollingData> polling = [];
  var articleProvider = ArticleProvider();

  Future<void> readJson() async {
    polling = (await articleProvider.getAllPolling())!;
    setState(() {
      _isLoading = true;
    });
  }

  @override
  void initState() {
    super.initState();
    readJson();
  }


  @override
  Widget build(BuildContext context) {
    return _isLoading ?
    ListView.builder(
      itemCount: polling.length,
      itemBuilder: (BuildContext context, int index) {
        return PollingCard(
          polling: const [],
          poll: polling[index],
        );
      },
    ):const Center(child: CircularProgressIndicator(),);
  }
}
