import 'package:flutter/material.dart';
import 'package:top_news_app/helper/custom_appbar.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:top_news_app/localization/localization.dart';
import '../model/notify.dart';
import '../providers/article_provider.dart';
import '../repos/exception_handlers.dart';
import '../services/auth_service.dart';



class NotificationScreen extends StatefulWidget {
  const NotificationScreen({Key? key}) : super(key: key);
  @override
  State<NotificationScreen> createState() => _NotificationScreenState();
}

class _NotificationScreenState extends State<NotificationScreen> {

  late bool _isLoading = false;
  var articleProvider = ArticleProvider();
  List<Data> notify = [];
  void loadingEffect() async {
    setState(() {
      _isLoading =true;
    });

    try {
      notify = (await articleProvider.getNotification())!;

    }catch($e){
      var message = ExceptionHandlers().getExceptionString($e);
      showMessage(message);
    }

    setState(() {
      _isLoading = false;
    });
  }

  makeRead(id) async{

    try {
      var authService = AuthService();
      var result = await authService.readNotify(id);

      if(result.containsKey('message')){
        showMessage(result['message']);
      }
    }catch($e){
      var message = ExceptionHandlers().getExceptionString($e);
      showMessage(message);
    }

  }

  @override
  void initState() {
    super.initState();
    loadingEffect();
  }



  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SafeArea(
      child: Scaffold(
        appBar: customAppBar(getTranslated(context, 'Notifications') ?? 'Notifications', '',context),
        body:  _isLoading
            ? const Center(
          child: CircularProgressIndicator(),
        )
            : RefreshIndicator(
          onRefresh: () async {
            loadingEffect();
          },
          child: Padding(
            padding: const EdgeInsets.symmetric(horizontal: 8),
            child: ListView.builder(
                shrinkWrap: true,
                physics: const ScrollPhysics(),
                itemCount: notify.length,
                itemBuilder: (BuildContext context, int index) => Dismissible(
                  key: UniqueKey(),
                  background: Container(
                    color: Colors.red,

                    child: const Align(
                        alignment: Alignment.centerRight,
                        child: Icon(Icons.remove_circle)),
                  ),
                  onDismissed: (directions) {
                    makeRead(notify[index].id);
                  },
                  child: Container(
                    padding: const EdgeInsets.all(10),
                    width: size.width,
                    decoration: const BoxDecoration(
                      border: Border(
                          bottom: BorderSide(
                            color: Colors.grey,
                          )),

                    ),
                    child: ListTile(
                      leading: Container(
                        decoration: const BoxDecoration(
                          shape: BoxShape.circle,
                        ),
                        child:  Container(
                          padding: const EdgeInsets.all(8),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: primaryColors.withOpacity(0.5)
                          ),
                          child: const Icon(Icons.notifications),
                        ),
                      ),
                      title: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text(
                            '${notify[index].title}',
                            style:  GoogleFonts.roboto(
                                fontWeight: FontWeight.w700, fontSize: 13),
                          ),
                          const SizedBox(height: 6,),
                          Text(
                            '${notify[index].message}',
                            style:  GoogleFonts.roboto(
                                fontWeight: FontWeight.w500, fontSize: 12),
                          ),
                        ],
                      ),
                      subtitle: Text(
                          '${notify[index].date}',
                          style:  GoogleFonts.roboto(
                              fontWeight: FontWeight.w700, fontSize: 11)),
                      onTap: () {},
                    ),
                  ),
                )),
          ),
        ),
      ),
    );
  }
}