class Comment {
  Comment({
      num? currentPage, 
      List<CommentData>? commentData, 
      String? firstPageUrl, 
      num? from, 
      num? lastPage, 
      String? lastPageUrl, 
      dynamic nextPageUrl, 
      String? path, 
      num? perPage, 
      dynamic prevPageUrl, 
      num? to, 
      num? total,}){
    _currentPage = currentPage;
    _commentData = commentData;
    _firstPageUrl = firstPageUrl;
    _from = from;
    _lastPage = lastPage;
    _lastPageUrl = lastPageUrl;
    _nextPageUrl = nextPageUrl;
    _path = path;
    _perPage = perPage;
    _prevPageUrl = prevPageUrl;
    _to = to;
    _total = total;
}

  Comment.fromJson(dynamic json) {
    _currentPage = json['current_page'];
    if (json['data'] != null) {
      _commentData = [];
      json['data'].forEach((v) {
        _commentData?.add(CommentData.fromJson(v));
      });
    }
    _firstPageUrl = json['first_page_url'];
    _from = json['from'];
    _lastPage = json['last_page'];
    _lastPageUrl = json['last_page_url'];
    _nextPageUrl = json['next_page_url'];
    _path = json['path'];
    _perPage = json['per_page'];
    _prevPageUrl = json['prev_page_url'];
    _to = json['to'];
    _total = json['total'];
  }
  num? _currentPage;
  List<CommentData>? _commentData;
  String? _firstPageUrl;
  num? _from;
  num? _lastPage;
  String? _lastPageUrl;
  dynamic _nextPageUrl;
  String? _path;
  num? _perPage;
  dynamic _prevPageUrl;
  num? _to;
  num? _total;
Comment copyWith({  num? currentPage,
  List<CommentData>? commentData,
  String? firstPageUrl,
  num? from,
  num? lastPage,
  String? lastPageUrl,
  dynamic nextPageUrl,
  String? path,
  num? perPage,
  dynamic prevPageUrl,
  num? to,
  num? total,
}) => Comment(  currentPage: currentPage ?? _currentPage,
  commentData: commentData ?? _commentData,
  firstPageUrl: firstPageUrl ?? _firstPageUrl,
  from: from ?? _from,
  lastPage: lastPage ?? _lastPage,
  lastPageUrl: lastPageUrl ?? _lastPageUrl,
  nextPageUrl: nextPageUrl ?? _nextPageUrl,
  path: path ?? _path,
  perPage: perPage ?? _perPage,
  prevPageUrl: prevPageUrl ?? _prevPageUrl,
  to: to ?? _to,
  total: total ?? _total,
);
  num? get currentPage => _currentPage;
  List<CommentData>? get commentData => _commentData;
  String? get firstPageUrl => _firstPageUrl;
  num? get from => _from;
  num? get lastPage => _lastPage;
  String? get lastPageUrl => _lastPageUrl;
  dynamic get nextPageUrl => _nextPageUrl;
  String? get path => _path;
  num? get perPage => _perPage;
  dynamic get prevPageUrl => _prevPageUrl;
  num? get to => _to;
  num? get total => _total;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['current_page'] = _currentPage;
    if (_commentData != null) {
      map['CommentData'] = _commentData?.map((v) => v.toJson()).toList();
    }
    map['first_page_url'] = _firstPageUrl;
    map['from'] = _from;
    map['last_page'] = _lastPage;
    map['last_page_url'] = _lastPageUrl;
    map['next_page_url'] = _nextPageUrl;
    map['path'] = _path;
    map['per_page'] = _perPage;
    map['prev_page_url'] = _prevPageUrl;
    map['to'] = _to;
    map['total'] = _total;
    return map;
  }

}

/// name : "rumon"
/// userId : 13
/// avatar : "http://localhost/news_dashboard/public/placeholder.png"
/// date : "1 second ago"
/// authorId : 4
/// postId : 22
/// message : "this si message"

class CommentData {
  CommentData({
      String? name, 
      num? userId, 
      String? avatar, 
      String? date, 
      num? authorId, 
      num? postId, 
      String? message,}){
    _name = name;
    _userId = userId;
    _avatar = avatar;
    _date = date;
    _authorId = authorId;
    _postId = postId;
    _message = message;
}

  CommentData.fromJson(dynamic json) {
    _name = json['name'];
    _userId = json['userId'];
    _avatar = json['avatar'];
    _date = json['date'];
    _authorId = json['authorId'];
    _postId = json['postId'];
    _message = json['message'];
  }
  String? _name;
  num? _userId;
  String? _avatar;
  String? _date;
  num? _authorId;
  num? _postId;
  String? _message;
CommentData copyWith({  String? name,
  num? userId,
  String? avatar,
  String? date,
  num? authorId,
  num? postId,
  String? message,
}) => CommentData(  name: name ?? _name,
  userId: userId ?? _userId,
  avatar: avatar ?? _avatar,
  date: date ?? _date,
  authorId: authorId ?? _authorId,
  postId: postId ?? _postId,
  message: message ?? _message,
);
  String? get name => _name;
  num? get userId => _userId;
  String? get avatar => _avatar;
  String? get date => _date;
  num? get authorId => _authorId;
  num? get postId => _postId;
  String? get message => _message;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['name'] = _name;
    map['userId'] = _userId;
    map['avatar'] = _avatar;
    map['date'] = _date;
    map['authorId'] = _authorId;
    map['postId'] = _postId;
    map['message'] = _message;
    return map;
  }

}