import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'app_localization.dart';

const String english = 'en';
const String indonesian = 'id';
const String spanish = 'es';
const String french = 'fr';
const String hindi = 'hi';
const String bangla = 'bn';
const String defaults = 'en';



Future<Locale> setLocale(String? languageCode) async {
  SharedPreferences prefs = await SharedPreferences.getInstance();
  await prefs.setString('defaultLanguages', defaults);
  return _locale(languageCode!);
}

Future<Locale> getLocale() async {
  SharedPreferences prefs = await SharedPreferences.getInstance();
  String languageCode = prefs.getString('defaultLanguages') ?? defaults;
  return _locale(languageCode);
}

Locale _locale(String languageCode) {
  switch (languageCode) {
    case english:
      return const Locale(english, 'US');
    case spanish:
      return const Locale(spanish, "ES");
    case french:
      return const Locale(french, "FR");
    case hindi:
      return const Locale(hindi, "HI");
    case bangla:
      return const Locale(bangla, "BN");
    case indonesian:
      return const Locale(indonesian, "ID");
    default:
      return const Locale(english, 'US');
  }
}

String? getTranslated(BuildContext context, String key) {
  return AppLocalization.of(context)?.getTranslatedValue(key);
}
