
import 'dart:ui';
import 'package:flutter/material.dart';
import 'package:shimmer/shimmer.dart';


class ImageCached extends StatefulWidget {
  final String? image;
  final double width;
  final double height;
  final BoxFit fit;
  final bool blur;
  const ImageCached({Key? key,
    required this.image,
    required this.width,
    required this.blur,
    required this.fit,
    required this.height}) : super(key: key);

  @override
  State<ImageCached> createState() => _ImageCachedState();
}

class _ImageCachedState extends State<ImageCached> {

  bool _isLoading = true;

  @override
  void initState() {

    super.initState();
    loadingEffect();
  }

  void loadingEffect() {
    Future.delayed(const Duration(microseconds: 100), () {
      setState(() {
        _isLoading = false;
      });
    });
  }
  @override
  Widget build(BuildContext context) {

    return _isLoading ? SizedBox(
      width: widget.width,
      height: widget.height,
      child: Shimmer.fromColors(
        baseColor: Colors.black12,
        highlightColor: Colors.white12,
        child: Container(
          width: widget.width-10,
          height: widget.height-10,
          decoration: BoxDecoration(
            color: Colors.white,
            shape: BoxShape.rectangle,
            borderRadius: BorderRadius.circular(8),
          ),
          child: const Text(''),
        ),
      ),
    ) : ClipRRect(
      borderRadius: BorderRadius.circular(10),
      child: Container(
        height: widget.height,
        width: widget.width,
        decoration: BoxDecoration(
          borderRadius :BorderRadius.circular(6),
          image: DecorationImage(
            image: NetworkImage('${widget.image}'),
            fit: widget.fit,
          )
      ),
        child: widget.blur ?  BackdropFilter(
          filter:  ImageFilter.blur(sigmaX: 1.0, sigmaY: 3.0),
          child:  Container(
            decoration:  BoxDecoration(color: Colors.grey.withOpacity(0.0)),
          ),
        ) : const Center(),
    ),
    );
  }
}


