
import 'package:flutter/material.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:font_awesome_flutter/font_awesome_flutter.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:top_news_app/localization/localization.dart';
import 'package:top_news_app/services/auth_service.dart';
import '../screen/email_login_screen.dart';
import '../screen/register_screen.dart';



String appsName = 'Top News';
String lightLogo = 'assets/logo.png';
String darkLogo = 'assets/logod.png';
var activeDropPointSplashScreen = primaryColors;
var deactivateDropPointSplashScreen = Colors.grey;

const double defaultAllSidePadding = 8;
const double fontSize = 14;

const Icon backButton = Icon(Icons.arrow_back);

String fontFamily = 'Regular';
const titleTextColor = Colors.black;
final titleTextStyle = TextStyle(
    color: titleTextColor,
    fontFamily: fontFamily,
    fontSize: 12,
    fontWeight: FontWeight.normal);

final titleColorTextStyle = TextStyle(
    color: primaryColorsAccent,
    fontFamily: fontFamily,
    fontSize: 12,
    fontWeight: FontWeight.w500);

const buttonTextColor = Colors.white;
const buttonTextStyle = TextStyle(
    color: buttonTextColor,
    fontWeight: FontWeight.w600,
    fontSize: 14);


const hintsTextColors = Colors.grey;
const hintsTextStyle = Colors.grey;
const iconBlack = Colors.black;
const textBlack = Colors.black;
const textWhite = Colors.white;
const double elevation = 5.0;


const primaryColors = Colors.blue;
const primaryColorsAccent = Colors.blueAccent;
const iconPrimaryColors = Colors.black54;

showMessage(message){
  Fluttertoast.showToast(msg: message,toastLength: Toast.LENGTH_LONG,
      backgroundColor: Colors.grey,textColor: Colors.white,gravity: ToastGravity.BOTTOM);
}


Widget customSizeBox(double value) {
  return SizedBox(
    height: value,
  );
}

Widget sectionTitle(VoidCallback onClick,String title,bool linkShow,context){
  return  Container(
    padding: const EdgeInsets.all(defaultAllSidePadding),
    height: 50,
    child: Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Container(
          decoration:  const BoxDecoration(
              border: Border(left: BorderSide(width: 3,color: primaryColors))
          ),
          child: Padding(
            padding: const EdgeInsets.only(left: 10),
            child: Text(getTranslated(context, title) ?? title,style: GoogleFonts.roboto(fontSize:16,fontWeight: FontWeight.w500),),
          ),
        ),

        linkShow ?  GestureDetector(
          onTap: (){
            onClick();
          },
          child:   Text(getTranslated(context, 'View all') ?? 'View all ',style: const TextStyle(fontWeight: FontWeight.w400),),
        ) : Container(),
      ],
    ),
  );
}



Future<void> dialogLogin(BuildContext context,) async {

  var authService = AuthService();

  return  showModalBottomSheet<void>(
      context: context,
      enableDrag: true,
      showDragHandle: true,
      clipBehavior: Clip.antiAliasWithSaveLayer,
      isScrollControlled: true,

      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.vertical(
          top: Radius.circular(25.0),
        )
      ),
      builder: (BuildContext context)
  {
    return  Container(
      height: 450,
      padding: const EdgeInsetsDirectional.fromSTEB(0, 44, 0, 0),
      child: Column(
        mainAxisSize: MainAxisSize.max,
        mainAxisAlignment: MainAxisAlignment.end,
        children: [
          Padding(
            padding: const EdgeInsets.symmetric(horizontal: 40),
            child: GestureDetector(
              onTap: () {
                Navigator.push(context, MaterialPageRoute(builder: (context)=>const RegistrationScreen()));
              },
              child: Container(
                height: 55,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8.0),
                  color: primaryColorsAccent,
                ),
                child:  Center(
                    child: Text(
                      getTranslated(context, 'Sign up') ?? 'Sign up',
                      style: GoogleFonts.robotoSerif(fontSize: 16,fontWeight: FontWeight.w500,color: Colors.white),
                    )),
              ),
            ),
          ),
          Padding(
            padding: const EdgeInsetsDirectional.fromSTEB(0, 12, 0, 12),
            child: Text(
              getTranslated(context, 'Or use social media') ?? 'Or use social media',
              style: GoogleFonts.robotoSerif(),
            ),
          ),

          Padding(
            padding: const EdgeInsets.symmetric(horizontal: 40),
            child: GestureDetector(
              onTap: () {
                authService.signInWithFacebook(context);
              },
              child: Container(
                height: 55,
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8.0),
                    border: Border.all(color: Colors.blue,width: 1)
                ),
                child:  Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    const Icon(Icons.facebook),
                    const SizedBox(
                      width: 10,
                    ),
                    Text(
                      getTranslated(context, 'Sign In With Facebook') ?? 'Sign In With Facebook',
                      style: GoogleFonts.robotoSerif(fontSize: 16,fontWeight: FontWeight.w500),
                    ),
                  ],
                ),
              ),
            ),
          ),
          customSizeBox(10),
          Padding(
            padding: const EdgeInsets.symmetric(horizontal: 40),
            child: GestureDetector(
              onTap: () {
                authService.signInWithGoogle(context);
              },
              child: Container(
                height: 55,
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8.0),
                    border: Border.all(color: Colors.red,width: 1)
                ),
                child:  Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    const Icon(FontAwesomeIcons.google),
                    const SizedBox(
                      width: 10,
                    ),
                    Text(
                      getTranslated(context, 'Sign In With Google') ?? 'Sign In With Google',
                      style: GoogleFonts.robotoSerif(fontSize: 16,fontWeight: FontWeight.w500),
                    ),
                  ],
                ),
              ),
            ),
          ),
          customSizeBox(10),
          Padding(
            padding: const EdgeInsetsDirectional.fromSTEB(0, 24, 0, 64),
            child:  Row(
              mainAxisAlignment: MainAxisAlignment.center,
              children: [
                Text(
                  getTranslated(context, 'Already have an account?') ?? 'Already have an account?',
                  style: GoogleFonts.robotoSerif(color: Colors.grey),
                ),
                const SizedBox(
                  width: 10,
                ),
                GestureDetector(
                  onTap: (){
                    Navigator.push(context, MaterialPageRoute(builder: (context)=>const EmailLoginScreen()));
                  },
                  child: Text(
                    getTranslated(context, 'Log In') ?? 'Log In',
                    style:GoogleFonts.robotoSerif(
                      fontWeight: FontWeight.bold,
                      color: primaryColors,
                    ),
                  ),
                )
              ],
            ),
          ),
          customSizeBox(60),
        ],
      ),
    );
  });

}


String formatTime(Duration duration){
  String twoDigits(int n) =>n.toString().padLeft(2,'0');
  final hours = twoDigits(duration.inHours);
  final minutes = twoDigits(duration.inMinutes.remainder(60));
  final seconds = twoDigits(duration.inSeconds.remainder(60));

  return[
    if(duration.inHours > 0) hours,
    minutes,
    seconds
  ].join(':');
}

