
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:top_news_app/screen/notification_screen.dart';
import 'package:top_news_app/widget/custom_search.dart';


 customAppBar(String title,key, BuildContext context){
  return AppBar(
    elevation: 0,
    backgroundColor: Colors.transparent,
    iconTheme: IconThemeData(
      size: 30,
      color: Theme.of(context).iconTheme.color
    ),
    title: title == 'image' ? Container(
      height: 150,
      width: 150,
      decoration: const BoxDecoration(
        image: DecorationImage(
          image: AssetImage('assets/long_logo.png',),
          fit: BoxFit.fitHeight
        )
      ),
    ) : Text(
      title,
      style: GoogleFonts.robotoSerif(
          color: Theme.of(context).iconTheme.color,
          fontWeight: FontWeight.bold),
    ),
    actions: [
      GestureDetector(
          onTap: (){
            showSearch(context: context, delegate: CustomSearch());
          },
          child: const Icon(Icons.search)),
   IconButton(
   icon: const Icon(Icons.notifications_none),
   onPressed: () {
     Navigator.push(context, MaterialPageRoute(builder: (context)=>const NotificationScreen()));
   }),
    ],
  );
}