import 'package:flutter/material.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:top_news_app/model/Article.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:simple_gradient_text/simple_gradient_text.dart';
import 'package:top_news_app/screen/author_post_screens.dart';
import '../screen/category_ways_post_list_screen.dart';
import '../screen/news_details_screen.dart';

class BookMarkNewsCardOne extends StatefulWidget {
  final ArticleData post;
  const BookMarkNewsCardOne({super.key,required this.post});

  @override
  State<BookMarkNewsCardOne> createState() => _BookMarkNewsCardOneState();
}

class _BookMarkNewsCardOneState extends State<BookMarkNewsCardOne> {
  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return Card(
      clipBehavior: Clip.antiAliasWithSaveLayer,
      elevation: 4,
      shape: RoundedRectangleBorder(
        borderRadius: BorderRadius.circular(8),
      ),
      child: Row(
        mainAxisSize: MainAxisSize.max,
        children: [
          GestureDetector(
            onTap: (){
              Navigator.push(context, MaterialPageRoute(builder: (context)=> NewsDetailsScreen(data: widget.post,)));
            },
            child: ClipRRect(
              borderRadius: BorderRadius.circular(8),
              child: Image.network(
                '${widget.post.thumbnail}',
                width: 140,
                height: 150,
                fit: BoxFit.cover,
              ),
            ),
          ),
          Padding(
            padding: const EdgeInsetsDirectional.fromSTEB(6, 0, 0, 0),
            child: SizedBox(
              width: size.width - 155,
              height: 150,
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  GestureDetector(
                    onTap: (){
                      Navigator.push(context, MaterialPageRoute(builder: (context)=>CategoryWaysPostListScreen(title: '${widget.post.categoriesName?[0]}', id: '${widget.post.categoriesId?[0]}',)));
                    },
                    child: Align(
                      alignment: const AlignmentDirectional(-1.00, 0.00),
                      child: Padding(
                        padding:
                        const EdgeInsetsDirectional.fromSTEB(0, 6, 0, 6),
                        child: GradientText(
                          '${widget.post.categoriesName?[0]}',
                          style: GoogleFonts.robotoSerif(
                              fontSize: 12,
                              fontWeight: FontWeight.normal
                          ),
                          colors: const [
                            primaryColors,
                            primaryColorsAccent
                          ],
                          gradientDirection: GradientDirection.ltr,
                          gradientType: GradientType.linear,
                        ),
                      ),
                    ),
                  ),
                  GestureDetector(
                    onTap: (){
                      Navigator.push(context, MaterialPageRoute(builder: (context)=> NewsDetailsScreen(data: widget.post,)));
                    },
                    child: Text(
                      '${widget.post.title}',
                      maxLines: 2,
                      style: GoogleFonts.robotoSerif(
                        fontSize: 14,
                        fontWeight: FontWeight.w500,
                      ),
                    ),
                  ),
                  customSizeBox(5),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.start,
                    children: [
                      GestureDetector(
                        onTap: (){
                          Navigator.push(context, MaterialPageRoute(builder: (context)=>AuthorPostScreens(name: '${widget.post.authorName}', id: '${widget.post.authorId}', image: '${widget.post.authorAvatar}', randomNumber: widget.post.randomNumber ?? 0,)));
                        },
                        child: Row(
                          mainAxisSize: MainAxisSize.max,
                          children: [
                            Hero(
                              tag: 'avatar-${widget.post.randomNumber}',
                              child: Container(
                                width: 20,
                                height: 20,
                                clipBehavior:
                                Clip.antiAlias,
                                decoration: const BoxDecoration(
                                  shape: BoxShape.circle,
                                ),
                                child: Image.network(
                                  '${widget.post.authorAvatar}',
                                  fit: BoxFit.cover,
                                ),
                              ),
                            ),
                            Padding(
                              padding: const EdgeInsets.symmetric(horizontal: 10),
                              child: Text(
                                '${widget.post.authorName}',
                                style: GoogleFonts.robotoSerif(
                                  fontWeight: FontWeight.w500,
                                ),
                              ),
                            ),
                          ],
                        ),
                      ),
                      customSizeBox(5),
                      Text(
                        '${widget.post.approvedAt}',
                        style: GoogleFonts.robotoSerif(
                          fontWeight: FontWeight.w400,
                        ),
                      ),
                    ],
                  ),
                  customSizeBox(5),
                  Row(
                    mainAxisSize: MainAxisSize.max,
                    children: [
                      Icon(
                        Icons.remove_red_eye,
                        color: Theme.of(context).iconTheme.color,
                        size: 18,
                      ),
                      Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 10),
                        child: Text(
                          '${widget.post.views}',
                          style: GoogleFonts.robotoSerif(
                            fontWeight: FontWeight.w500,
                          ),
                        ),
                      ),
                    ],
                  ),
                  customSizeBox(4),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}
