class Polling {
  Polling({
      List<PollingData>? pollingData,}){
    _pollingData = pollingData;
}

  Polling.fromJson(dynamic json) {
    if (json['data'] != null) {
      _pollingData = [];
      json['data'].forEach((v) {
        _pollingData?.add(PollingData.fromJson(v));
      });
    }
  }
  List<PollingData>? _pollingData;
Polling copyWith({  List<PollingData>? pollingData,
}) => Polling(  pollingData: pollingData ?? _pollingData,
);
  List<PollingData>? get pollingData => _pollingData;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_pollingData != null) {
      map['data'] = _pollingData?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

/// showResult : false
/// id : 2
/// questions : "Which party do you support to handle sensitive topics such as national security"
/// options : [{"pollingId":2,"optionId":3,"option":"Democrats","totalVot":0,"youVot":false},{"pollingId":2,"optionId":4,"option":"Republicans","totalVot":0,"youVot":false},{"pollingId":2,"optionId":5,"option":"Don’t know","totalVot":0,"youVot":false},{"pollingId":2,"optionId":6,"option":"I don’t support any party","totalVot":0,"youVot":false}]

class PollingData {
  PollingData({
      bool? showResult, 
      num? id, 
      String? questions, 
      List<Options>? options,}){
    _showResult = showResult;
    _id = id;
    _questions = questions;
    _options = options;
}

  PollingData.fromJson(dynamic json) {
    _showResult = json['showResult'];
    _id = json['id'];
    _questions = json['questions'];
    if (json['options'] != null) {
      _options = [];
      json['options'].forEach((v) {
        _options?.add(Options.fromJson(v));
      });
    }
  }
  bool? _showResult;
  num? _id;
  String? _questions;
  List<Options>? _options;
PollingData copyWith({  bool? showResult,
  num? id,
  String? questions,
  List<Options>? options,
}) => PollingData(  showResult: showResult ?? _showResult,
  id: id ?? _id,
  questions: questions ?? _questions,
  options: options ?? _options,
);
  bool? get showResult => _showResult;
  num? get id => _id;
  String? get questions => _questions;
  List<Options>? get options => _options;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['showResult'] = _showResult;
    map['id'] = _id;
    map['questions'] = _questions;
    if (_options != null) {
      map['options'] = _options?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

/// pollingId : 2
/// optionId : 3
/// option : "Democrats"
/// totalVot : 0
/// youVot : false

class Options {
  Options({
    String? pollingId,
      num? optionId, 
      String? option, 
      num? totalVot, 
      bool? youVot,}){
    _pollingId = pollingId;
    _optionId = optionId;
    _option = option;
    _totalVot = totalVot;
    _youVot = youVot;
}

  Options.fromJson(dynamic json) {
    _pollingId = json['pollingId'];
    _optionId = json['optionId'];
    _option = json['option'];
    _totalVot = json['totalVot'];
    _youVot = json['youVot'];
  }
  String? _pollingId;
  num? _optionId;
  String? _option;
  num? _totalVot;
  bool? _youVot;
Options copyWith({  String? pollingId,
  num? optionId,
  String? option,
  num? totalVot,
  bool? youVot,
}) => Options(  pollingId: pollingId ?? _pollingId,
  optionId: optionId ?? _optionId,
  option: option ?? _option,
  totalVot: totalVot ?? _totalVot,
  youVot: youVot ?? _youVot,
);
  String? get pollingId => _pollingId;
  num? get optionId => _optionId;
  String? get option => _option;
  num? get totalVot => _totalVot;
  bool? get youVot => _youVot;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['pollingId'] = _pollingId;
    map['optionId'] = _optionId;
    map['option'] = _option;
    map['totalVot'] = _totalVot;
    map['youVot'] = _youVot;
    return map;
  }

}