class Article {
  Article({
      num? currentPage, 
      List<ArticleData>? articleData, 
      String? firstPageUrl, 
      num? from, 
      num? lastPage, 
      String? lastPageUrl, 
      dynamic nextPageUrl, 
      String? path, 
      num? perPage, 
      dynamic prevPageUrl, 
      num? to, 
      num? total,}){
    _currentPage = currentPage;
    data = articleData;
    _firstPageUrl = firstPageUrl;
    _from = from;
    _lastPage = lastPage;
    _lastPageUrl = lastPageUrl;
    _nextPageUrl = nextPageUrl;
    _path = path;
    _perPage = perPage;
    _prevPageUrl = prevPageUrl;
    _to = to;
    _total = total;
}

  Article.fromJson(dynamic json) {
    _currentPage = json['current_page'];
    if (json['data'] != null) {
      data = [];
      json['data'].forEach((v) {
        data?.add(ArticleData.fromJson(v));
      });
    }
    _firstPageUrl = json['first_page_url'];
    _from = json['from'];
    _lastPage = json['last_page'];
    _lastPageUrl = json['last_page_url'];
    _nextPageUrl = json['next_page_url'];
    _path = json['path'];
    _perPage = json['per_page'];
    _prevPageUrl = json['prev_page_url'];
    _to = json['to'];
    _total = json['total'];
  }
  num? _currentPage;
  List<ArticleData>? data;
  String? _firstPageUrl;
  num? _from;
  num? _lastPage;
  String? _lastPageUrl;
  dynamic _nextPageUrl;
  String? _path;
  num? _perPage;
  dynamic _prevPageUrl;
  num? _to;
  num? _total;
Article copyWith({  num? currentPage,
  List<ArticleData>? articleData,
  String? firstPageUrl,
  num? from,
  num? lastPage,
  String? lastPageUrl,
  dynamic nextPageUrl,
  String? path,
  num? perPage,
  dynamic prevPageUrl,
  num? to,
  num? total,
}) => Article(  currentPage: currentPage ?? _currentPage,
  articleData: articleData ?? data,
  firstPageUrl: firstPageUrl ?? _firstPageUrl,
  from: from ?? _from,
  lastPage: lastPage ?? _lastPage,
  lastPageUrl: lastPageUrl ?? _lastPageUrl,
  nextPageUrl: nextPageUrl ?? _nextPageUrl,
  path: path ?? _path,
  perPage: perPage ?? _perPage,
  prevPageUrl: prevPageUrl ?? _prevPageUrl,
  to: to ?? _to,
  total: total ?? _total,
);
  num? get currentPage => _currentPage;
  List<ArticleData>? get articleData => data;
  String? get firstPageUrl => _firstPageUrl;
  num? get from => _from;
  num? get lastPage => _lastPage;
  String? get lastPageUrl => _lastPageUrl;
  dynamic get nextPageUrl => _nextPageUrl;
  String? get path => _path;
  num? get perPage => _perPage;
  dynamic get prevPageUrl => _prevPageUrl;
  num? get to => _to;
  num? get total => _total;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['current_page'] = _currentPage;
    if (data != null) {
      map['data'] = data?.map((v) => v.toJson()).toList();
    }
    map['first_page_url'] = _firstPageUrl;
    map['from'] = _from;
    map['last_page'] = _lastPage;
    map['last_page_url'] = _lastPageUrl;
    map['next_page_url'] = _nextPageUrl;
    map['path'] = _path;
    map['per_page'] = _perPage;
    map['prev_page_url'] = _prevPageUrl;
    map['to'] = _to;
    map['total'] = _total;
    return map;
  }

}


class ArticleData {
  ArticleData({
      String? authorId,
      String? authorName, 
      String? authorAvatar,
     String? views,
      int? randomNumber,
      num? comments,
      String? type, 
      num? postId, 
      String? title, 
      String? slug, 
      String? thumbnail, 
      String? shortContent, 
      List<String>? categoriesId, 
      List<String>? tags, 
      bool? bookmark, 
      List<String>? categoriesName, 
      String? approvedAt, 
      List<Details>? details,}){
    _authorId = authorId;
    _authorName = authorName;
    _authorAvatar = authorAvatar;
    _views = views;
    _randomNumber = randomNumber;
    _comments = comments;
    _type = type;
    _postId = postId;
    _title = title;
    _slug = slug;
    _thumbnail = thumbnail;
    _shortContent = shortContent;
    _categoriesId = categoriesId;
    _tags = tags;
    _bookmark = bookmark;
    _categoriesName = categoriesName;
    _approvedAt = approvedAt;
    _details = details;
}

  ArticleData.fromJson(dynamic json) {
    _authorId = json['authorId'];
    _authorName = json['authorName'];
    _authorAvatar = json['authorAvatar'];
    _views = json['views'];
    _randomNumber = json['randomNumber'];
    _comments = json['comments'];
    _type = json['type'];
    _postId = json['postId'];
    _title = json['title'];
    _slug = json['slug'];
    _thumbnail = json['thumbnail'];
    _shortContent = json['shortContent'];
    _categoriesId = json['categoriesId'] != null ? json['categoriesId'].cast<String>() : [];
    _tags = json['tags'] != null ? json['tags'].cast<String>() : [];
    _bookmark = json['bookmark'];
    _categoriesName = json['categoriesName'] != null ? json['categoriesName'].cast<String>() : [];
    _approvedAt = json['approvedAt'];
    if (json['details'] != null) {
      _details = [];
      json['details'].forEach((v) {
        _details?.add(Details.fromJson(v));
      });
    }
  }
  String? _authorId;
  String? _authorName;
  String? _authorAvatar;
  String? _views;
  int? _randomNumber;
  num? _comments;
  String? _type;
  num? _postId;
  String? _title;
  String? _slug;
  String? _thumbnail;
  String? _shortContent;
  List<String>? _categoriesId;
  List<String>? _tags;
  bool? _bookmark;
  List<String>? _categoriesName;
  String? _approvedAt;
  List<Details>? _details;
ArticleData copyWith({  String? authorId,
  String? authorName,
  String? authorAvatar,
  String? views,
  int? randomNumber,
  num? comments,
  String? type,
  num? postId,
  String? title,
  String? slug,
  String? thumbnail,
  String? shortContent,
  List<String>? categoriesId,
  List<String>? tags,
  bool? bookmark,
  List<String>? categoriesName,
  String? approvedAt,
  List<Details>? details,
}) => ArticleData(  authorId: authorId ?? _authorId,
  authorName: authorName ?? _authorName,
  authorAvatar: authorAvatar ?? _authorAvatar,
  views: views ?? _views,
  randomNumber: randomNumber ?? _randomNumber,
  comments: comments ?? _comments,
  type: type ?? _type,
  postId: postId ?? _postId,
  title: title ?? _title,
  slug: slug ?? _slug,
  thumbnail: thumbnail ?? _thumbnail,
  shortContent: shortContent ?? _shortContent,
  categoriesId: categoriesId ?? _categoriesId,
  tags: tags ?? _tags,
  bookmark: bookmark ?? _bookmark,
  categoriesName: categoriesName ?? _categoriesName,
  approvedAt: approvedAt ?? _approvedAt,
  details: details ?? _details,
);
  String? get authorId => _authorId;
  String? get authorName => _authorName;
  String? get authorAvatar => _authorAvatar;
  String? get views => _views;
  int? get randomNumber => _randomNumber;
  num? get comments => _comments;
  String? get type => _type;
  num? get postId => _postId;
  String? get title => _title;
  String? get slug => _slug;
  String? get thumbnail => _thumbnail;
  String? get shortContent => _shortContent;
  List<String>? get categoriesId => _categoriesId;
  List<String>? get tags => _tags;
  bool? get bookmark => _bookmark;
  List<String>? get categoriesName => _categoriesName;
  String? get approvedAt => _approvedAt;
  List<Details>? get details => _details;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['authorId'] = _authorId;
    map['authorName'] = _authorName;
    map['authorAvatar'] = _authorAvatar;
    map['views'] = _views;
    map['comments'] = _comments;
    map['type'] = _type;
    map['postId'] = _postId;
    map['title'] = _title;
    map['slug'] = _slug;
    map['thumbnail'] = _thumbnail;
    map['shortContent'] = _shortContent;
    map['categoriesId'] = _categoriesId;
    map['tags'] = _tags;
    map['bookmark'] = _bookmark;
    map['categoriesName'] = _categoriesName;
    map['approvedAt'] = _approvedAt;
    if (_details != null) {
      map['details'] = _details?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

/// id : 102
/// postId : 23
/// sorting : 0
/// type : "youtube_video"
/// content : "https://youtu.be/AlI7Q95WhIU?si=CfCbLGyGzOy1l-fV"

class Details {
  Details({
      num? id, 
      String? postId,
    String? sorting,
      String? type, 
      String? content,}){
    _id = id;
    _postId = postId;
    _sorting = sorting;
    _type = type;
    _content = content;
}

  Details.fromJson(dynamic json) {
    _id = json['id'] ?? 0;
    _postId = json['postId'] ?? 0;
    _sorting = json['sorting'] ?? 0;
    _type = json['type'] ?? 'no';
    _content = json['content'] ?? 'no';
  }
  num? _id;
  String? _postId;
  String? _sorting;
  String? _type;
  String? _content;
Details copyWith({  num? id,
  String? postId,
  String? sorting,
  String? type,
  String? content,
}) => Details(  id: id ?? _id,
  postId: postId ?? _postId,
  sorting: sorting ?? _sorting,
  type: type ?? _type,
  content: content ?? _content,
);
  num? get id => _id;
  String? get postId => _postId;
  String? get sorting => _sorting;
  String? get type => _type;
  String? get content => _content;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['postId'] = _postId;
    map['sorting'] = _sorting;
    map['type'] = _type;
    map['content'] = _content;
    return map;
  }

}