import 'package:flutter/material.dart';
import 'package:top_news_app/widget/newscard_widget_lg_one.dart';
import 'package:top_news_app/widget/newscard_widget_lg_three.dart';
import 'package:top_news_app/widget/newscard_widget_lg_two.dart';
import 'package:top_news_app/widget/newscard_widget_md_one.dart';
import 'package:top_news_app/widget/newscard_widget_md_two.dart';
import 'package:top_news_app/widget/newscard_widget_sm_one.dart';
import 'package:top_news_app/widget/newscard_widget_sm_two.dart';
import 'package:top_news_app/widget/newscard_widget_transparent_one.dart';
import 'package:top_news_app/widget/newscard_widget_transparent_two.dart';
import '../model/Article.dart';

class PostWidget extends StatefulWidget {
  final List<ArticleData> posts ;
  const PostWidget({super.key, required this.posts});

  @override
  State<PostWidget> createState() => _PostWidgetState();
}

class _PostWidgetState extends State<PostWidget> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: List.generate(widget.posts.length,(index){
        switch(widget.posts[index].type) {
        case 'NewsCardWidgetLgOne': {
        return   NewsCardWidgetLgOne(post: widget.posts[index],);
        }
        case 'NewsCardWidgetLgThree': {
          return  NewsCardWidgetLgThree(post: widget.posts[index],);
        }
          case 'NewsCardWidgetLgTwo': {
            return  NewsCardWidgetLgTwo(post: widget.posts[index],);
          }
          case 'NewsCardWidgetMdOne': {
            return  NewsCardWidgetMdOne(post: widget.posts[index],);
          }
          case 'NewsCardWidgetMdTwo': {
            return  NewsCardWidgetMdTwo(post: widget.posts[index],);
          }
          case 'NewsCardWidgetSmOne': {
            return  NewsCardWidgetSmOne(post: widget.posts[index],);
          }
          case 'NewsCardWidgetSmTwo': {
            return  NewsCardWidgetSmTwo(post: widget.posts[index],);
          }
          case 'NewsCardWidgetTransparentOne': {
            return  NewsCardWidgetTransparentOne(post: widget.posts[index],);
          }
          case 'NewsCardWidgetTransparentTwo': {
            return  NewsCardWidgetTransparentTwo(post: widget.posts[index],);
          }
        default: {
          return  NewsCardWidgetTransparentTwo(post: widget.posts[index],);
        }
        }
      })
    );
  }
}
