import 'package:top_news_app/helper/image_cached.dart';
import 'package:top_news_app/screen/category_ways_post_list_screen.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:flutter/material.dart';

class CategoryWidget extends StatelessWidget {

  final num id;
  final String name;
  final String image;
  final double height;
  final double width;
  final double fontSize;
  const CategoryWidget({Key? key,required this.id,required this.name,required this.image,required this.width,required this.height, required this.fontSize}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Card(
      elevation: 0,
      child: GestureDetector(
        onTap: (){
          Navigator.push(context, MaterialPageRoute(builder: (context)=>CategoryWaysPostListScreen(title: name, id: id.toString())));
        },
        child: Container(
          padding: const EdgeInsets.all(6),
          decoration: BoxDecoration(
            shape: BoxShape.rectangle,
            borderRadius: BorderRadius.circular(6),
            gradient: LinearGradient(
              begin: Alignment.topRight,
              end: Alignment.bottomLeft,
              colors: [
                Theme.of(context).primaryColor.withOpacity(0.3),
                Colors.grey.withOpacity(0.2),
              ],
            ),
          ),
          child: Stack(
            children: [
              ImageCached(
                  blur: true,
                  height: height, width: width, image: image,fit: BoxFit.fill),
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 8),
                child: Align(
                  alignment: Alignment.center,
                    child: Text(name, style: GoogleFonts.robotoSerif(fontWeight: FontWeight.w700,fontSize: fontSize,color: Colors.white))),
              ),

            ],
          ),
        ),
      ),

    );
  }
}