import 'package:flutter/material.dart';
import 'package:getwidget/components/button/gf_button.dart';
import 'package:getwidget/shape/gf_button_shape.dart';
import 'package:top_news_app/helper/custom_appbar.dart';
import 'package:top_news_app/helper/helper.dart';
import 'package:google_fonts/google_fonts.dart';
import 'package:top_news_app/repos/exception_handlers.dart';
import '../localization/localization.dart';
import '../services/auth_service.dart';

class ChangePassword extends StatefulWidget {
  const ChangePassword({Key? key}) : super(key: key);

  @override
  State<ChangePassword> createState() => _ChangePasswordState();
}

class _ChangePasswordState extends State<ChangePassword> {
  var oldPassword = TextEditingController();
  var newPassword = TextEditingController();
  var new2Password = TextEditingController();
  var authService = AuthService();
  updatePassword() async {
    if (newPassword.text.length < 8) {
      showMessage(getTranslated(context, 'Password must be 8 charter') ??
          'Password must be 8 charter');
    } else if (newPassword.text != new2Password.text) {
      showMessage(getTranslated(
              context, 'New Password and Confirm Password is not change') ??
          'New Password and Confirm Password is not change');
    } else {
      try {
        var response = await authService.changePassword(
            newPassword.text, oldPassword.text);
        var result = processResponse(response);
        if (result.containsKey('message')) {
          showMessage(result['message']);
        }
        oldPassword.text = '';
        new2Password.text = '';
        newPassword.text = '';
      } catch (e) {
        rethrow;
      }
    }
  }

  @override
  Widget build(BuildContext context) {
    Size size = MediaQuery.of(context).size;
    return SafeArea(
      child: Scaffold(
        resizeToAvoidBottomInset: false,
        appBar: customAppBar(
            '${getTranslated(context, 'Change Password') ?? 'Change Password'} ',
            'back',
            context),
        body: SingleChildScrollView(
          physics: const NeverScrollableScrollPhysics(),
          scrollDirection: Axis.vertical,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: <Widget>[
              Column(
                children: <Widget>[
                  ConstrainedBox(
                    constraints: BoxConstraints(
                        maxWidth: size.width / 2.2, maxHeight: 140),
                    child: Container(
                      decoration: BoxDecoration(
                        image: DecorationImage(
                            image:
                                Theme.of(context).brightness == Brightness.dark
                                    ? AssetImage(darkLogo)
                                    : AssetImage(lightLogo)),
                      ),
                    ),
                  ),
                  const SizedBox(
                    height: 30,
                  ),
                ],
              ),
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 40),
                child: Column(
                  children: <Widget>[
                    makeInput(
                        label: getTranslated(context, 'Enter Old Password') ??
                            'Enter Old Password',
                        obscureText: true,
                    controller: oldPassword),
                    makeInput(
                        label: getTranslated(context, 'Enter New Password') ??
                            'Enter New Password',
                        obscureText: true,
                    controller: newPassword),
                    makeInput(
                        label:
                            getTranslated(context, 'Enter Repeat Password') ??
                                'Enter Repeat Password',
                        obscureText: true,controller: new2Password),
                  ],
                ),
              ),
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 40),
                child: GFButton(
                  onPressed: () {
                    updatePassword();
                  },
                  text: getTranslated(context, 'Update Password') ??
                      'Update Password',
                  color: primaryColors,
                  textStyle: GoogleFonts.roboto(
                      color: Colors.white, fontWeight: FontWeight.bold),
                  icon: const Icon(Icons.password, size: 12),
                  shape: GFButtonShape.standard,
                  blockButton: true,
                ),
              ),
              const SizedBox(
                height: 10,
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget makeInput({label, obscureText = false, controller}) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Text(
          label,
          style: GoogleFonts.roboto(fontSize: 14, fontWeight: FontWeight.w400),
        ),
        const SizedBox(
          height: 5,
        ),
        TextField(
          obscureText: obscureText,
          controller: controller,
          decoration: InputDecoration(
            hintText: label.toString(),
            hintStyle: GoogleFonts.robotoSerif(color: Colors.grey),
            contentPadding:
                const EdgeInsets.symmetric(vertical: 0, horizontal: 10),
            enabledBorder: const OutlineInputBorder(
                borderSide: BorderSide(color: Colors.grey)),
            border: const OutlineInputBorder(
                borderSide: BorderSide(color: Colors.grey)),
          ),
        ),
        const SizedBox(
          height: 30,
        ),
      ],
    );
  }
}
