
import 'dart:convert';
import 'package:http/http.dart' as http;
import 'package:image_picker/image_picker.dart';
import 'package:shared_preferences/shared_preferences.dart';

class Repository {



  final String url = 'https://topnews.ityadimart.com/api/';


  setToken() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getString('token');
  }



  //http get functions
  httpGet(String api) async {
    String? token = await setToken();
    try {
    return await http.get(Uri.parse('$url$api'),
        headers: {"Authorization": 'Bearer $token',
          'Content-Type': 'application/json',
          'Accept':'application/json',}
    );
    } catch (exception) {
      rethrow;
    }
  }

  //http get method with filter data
  httpGetWithData(String api,data) async {
    String? token = await setToken();
    try {
    return await http.get(Uri.parse('$url$api?filter=$data'),
        headers: {"Authorization": 'Bearer $token',
          'Content-Type': 'application/x-www-form-urlencoded',
          'Accept':'application/json',});
    } catch (exception) {
      rethrow;
    }
  }

  //http get by id
  httpGetById(String api, id) async {
    String? token = await setToken();
    try {
    return await http.get(Uri.parse('$url$api/$id'),
        headers: {"Authorization": 'Bearer $token',
          'Content-Type': 'application/json',
          'Accept':'application/json',});
    } catch (exception) {
      rethrow;
    }
  }

  //http post request functions
  httpPost(String api, data) async {
    String? token = await setToken();
    try {
    return await http.post(Uri.parse('$url''$api'), body: data,
        headers: {"Authorization": 'Bearer $token',
          'Content-Type': 'application/x-www-form-urlencoded',
          'Accept':'application/json',});
    } catch (exception) {
      rethrow;
  }
  }

  //http put request with data
  httpPut(String api, data) async {
    String? token = await setToken();
    try {
    return await http.put(
        Uri.parse('$url$api'),
        body: data,
        headers: {"Authorization": 'Bearer $token',
          'Content-Type': 'application/json',
          'Accept':'application/json',});
    } catch (exception) {
      rethrow;
    }
  }


  //http put request function
  httpPutWithId(String api, data, int id) async {
    String? token = await setToken();
    try {
    return await http.put(Uri(host: '$url$api/$id'),
        body: data,
        headers: {"Authorization": 'Bearer $token',
          'Content-Type': 'application/json',
          'Accept':'application/json',});
    } catch (exception) {
      rethrow;
    }
  }



  //http delete
  httpDelete(String api, int id) async {
    String? token = await setToken();
    try {
    return await http
        .delete(Uri.parse('$url$api/${id.toString()}'),
        encoding: Encoding.getByName('utf-8'), //it's for encoding
        headers: {"Authorization": 'Bearer $token',
          'Content-Type': 'application/json',
          'Accept':'application/json',});
    } catch (exception) {
      rethrow;
    }
  }




  //http get url
  fullUrlHttpGet(String api) async{
    String? token = await setToken();
    try {
    return await http.get(Uri.parse(api),
        headers: {
          "Authorization": 'Bearer $token',
          'Content-Type': 'application/x-www-form-urlencoded',
          'Accept':'application/json',});
    } catch (exception) {
      rethrow;
    }
  }


  jsonToFormData(http.MultipartRequest request, Map<String, dynamic> data) {
    for (var key in data.keys) {
      request.fields[key] = data[key].toString();
    }
    return request;
  }


  httpFileUpload(String api , XFile image,String ticketId) async {
    String? token = await setToken();
    final url = Uri.parse('${this.url}$api');
    var request = http.MultipartRequest('POST', url);
    request.headers.addAll(<String, String>{
      "Authorization": 'Bearer $token',
      'Content-Type': 'multipart/form-data',
      'Accept':'application/json',
    });
    request.fields['ticketId'] = ticketId;
    request.files.add(await http.MultipartFile.fromPath('file', image.path));
    var streamedResponse = await request.send();
    var response = await http.Response.fromStream(streamedResponse);
    return response;
  }



}
