class PostCategory {
  PostCategory({
      List<PostCategoryData>? postCategoryData,}){
    _postCategoryData = postCategoryData;
}

  PostCategory.fromJson(dynamic json) {
    if (json['data'] != null) {
      _postCategoryData = [];
      json['data'].forEach((v) {
        _postCategoryData?.add(PostCategoryData.fromJson(v));
      });
    }
  }
  List<PostCategoryData>? _postCategoryData;
PostCategory copyWith({  List<PostCategoryData>? postCategoryData,
}) => PostCategory(  postCategoryData: postCategoryData ?? _postCategoryData,
);
  List<PostCategoryData>? get postCategoryData => _postCategoryData;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_postCategoryData != null) {
      map['data'] = _postCategoryData?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

/// id : 2
/// image : "http://localhost/news_dashboard/public/placeholder.png"
/// name : "War in Ukraine"
/// childrens : []

class PostCategoryData {
  PostCategoryData({
      num? id, 
      String? image, 
      String? name, 
      List<PostCategoryData>? childrens,}){
    _id = id;
    _image = image;
    _name = name;
    _childrens = childrens;
}

  PostCategoryData.fromJson(dynamic json) {
    _id = json['id'];
    _image = json['image'];
    _name = json['name'];
    if (json['childrens'] != null) {
      _childrens = [];
      json['childrens'].forEach((v) {
        _childrens?.add(PostCategoryData.fromJson(v));
      });
    }
  }
  num? _id;
  String? _image;
  String? _name;
  List<PostCategoryData>? _childrens;
PostCategoryData copyWith({  num? id,
  String? image,
  String? name,
  List<PostCategoryData>? childrens,
}) => PostCategoryData(  id: id ?? _id,
  image: image ?? _image,
  name: name ?? _name,
  childrens: childrens ?? _childrens,
);
  num? get id => _id;
  String? get image => _image;
  String? get name => _name;
  List<PostCategoryData>? get childrens => _childrens;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['image'] = _image;
    map['name'] = _name;
    if (_childrens != null) {
      map['childrens'] = _childrens?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}